package de.bebagoe.jfxcontrols;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.ContentDisplay;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class BasicControls extends Application {
    private int numClicks = 0;
    private int iconInd = 0;

    @Override
    public void start(Stage stage) {
        var root = new BorderPane();
        int dist = 10;
        root.setPadding(new Insets(dist, dist, dist, dist));
        var vbox = new VBox(dist);

		String lblPrefix = "Zählerstand: ";
		var lblText = new Label(lblPrefix + "0");

        Image[] icons = new Image[3];
        icons[0] = new Image(getClass().getResourceAsStream("duke.png"));
        icons[1] = new Image(getClass().getResourceAsStream("fight.gif"));
        icons[2] = new Image(getClass().getResourceAsStream("snooze.gif"));
        ImageView imageView = new ImageView(icons[0]);
        imageView.fitHeightProperty().bind(root.heightProperty().subtract(2*dist));
        var lblIcon = new Label();
        lblIcon.setGraphic(imageView);

//		lblIcon = new Label("Duke");
//		lblIcon.setGraphic(imageView);
//		lblIcon.setContentDisplay(ContentDisplay.LEFT);
//		lblIcon.setGraphicTextGap(10);

        var btnAdd = new Button("Zählerstand _erhöhen");
		btnAdd.setOnAction(event -> {
			numClicks++;
			lblText.setText(lblPrefix + numClicks);
			if (iconInd < icons.length-1)
				iconInd++;
			else
				iconInd = 0;
			imageView.setImage(icons[iconInd]);
		});
//        btnAdd.setMnemonicParsing(false); // Kurzwahldefinition per Unterstrich deaktivieren

		// Der Default Button wird per Hintergrundfarbe hervorgehoben.
		// Als Fokusinhaber ist ein Schalter auf jeden Fall per Enter und Leertaste auslösbar.
//		btnAdd.setDefaultButton(true);

        vbox.getChildren().addAll(btnAdd, lblText);
        vbox.setAlignment(Pos.CENTER);
        root.setLeft(vbox);
        root.setCenter(lblIcon);

        Scene scene = new Scene(root, 340, 150);
        stage.setScene(scene);
        stage.setTitle("Multi Purpose Counter");
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}
